﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Text;
using System.Windows.Forms;

namespace SID_monitor
{
    public partial class PanelDataAcquisition : UserControl
    {
        public PanelDataAcquisition()
        {
            InitializeComponent();

            this.numericUpDownAckUpdate.Value = SID_monitor.Properties.Settings.Default.AcquisitionUpdate / 1000;
            this.numericUpDownGOESUpdate.Value = SID_monitor.Properties.Settings.Default.GOESUpdate / 3600000;


        }

        #region Properties
        public int AcquisitionUpdateValue
        {
            get
            {
                return (int)(this.numericUpDownAckUpdate.Value * 1000);
            }
        }

        public int GOESUpdateValue
        {
            get
            {
                return (int)(this.numericUpDownGOESUpdate.Value * 3600000);
            }
        }
        #endregion

        private void numericUpDownGOESUpdate_ValueChanged(object sender, EventArgs e)
        {
            if (this.numericUpDownGOESUpdate.Value == 0)
            {
                this.checkBoxSecondaryGOESUpdate.Enabled = false;
            }
            else
            {
                this.checkBoxSecondaryGOESUpdate.Enabled = true;
            }
        }


        #region ValidData Event
        public event SID_monitor.ValidDataEventHandler ValidData;

        protected virtual void OnValidData(SID_monitor.validDataEventArgs e)
        {
            if (ValidData != null)
            {
                // Invokes the delegates. 
                ValidData(this, e);
            }
        }
        #endregion

  

    }
}
